<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Capacitacion;
use App\Models\Tupa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class TupaController extends Controller
{

    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.transparencia.tupa.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);

            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('tupa as t')
            ->select(
                't.id',
                't.nombre',
                't.monto',
            )
            ->get();

            if($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
            } else if($variable == "div") {
                return response()->json($data);
            } else if($variable >= 0){
                $item = Tupa::find($variable);
                return response()->json($item);
            }

        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);

        } else {

            // nuevo objeto
            $item = new Tupa();

            $item->nombre = $request->input('txt-nombre');
            $item->monto = $request->input('txt-monto');

            $item->save();

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);

        } else {

            $item = Tupa::find($id);

            $item->nombre = $request->input('txt-nombre');
            $item->monto = $request->input('txt-monto');

            $item->save();

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }

    }


    public function destroy($id)
    {

        $item = Tupa::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
    
}
