<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\InicioTopbar;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class TopbarController extends Controller
{
    //ACCESO POR VALIDACIÓN
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //Si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.inicio.topbar.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('inicio_topbar as itb')
                ->select(
                    'itb.id',
                    'itb.titulo',
                    'itb.correo',
                    'itb.telefono',
                    'itb.ubicacion',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = InicioTopbar::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    // public function store(Request $request)
    // {
    //     // validar documento
    //     $validator = Validator::make($request->all(), [
    //         'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
    //     ], [
    //         'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
    //         'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
    //     ]);

    //     if ($validator->fails()) {

    //         return response()->json([
    //             "status" => 'validators',
    //             "mensaje" => $validator->errors(),
    //         ]);
    //     } else {

    //         // nuevo objeto
    //         $item = new InicioTopbar();

    //         $item->titulo = $request->input('txt-titulo');
    //         $item->correo = $request->input('txt-correo');
    //         $item->telefono = $request->input('txt-telefono');
    //         $item->ubicacion = $request->input('txt-ubicacion');

    //         $item->save();

    //         if ($item->save()) {
    //             return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
    //         } else {
    //             return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
    //         }
    //     }
    // }

    public function store(Request $request)
    {
    // validar documento
    $validator = Validator::make($request->all(), [
        'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 5000 KB
    ], [
        'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
        'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
    ]);

    if ($validator->fails()) {
        return response()->json([
            "status" => 'validators',
            "mensaje" => $validator->errors(),
        ]);
    } else {
        // Verificar si ya existe un registro
        $existingItem = InicioTopbar::first(); // Asumiendo que solo debería haber un registro

        if ($existingItem) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El topbar ya existe. Por favor, actualízalo.'
            ]);
        }

        // nuevo objeto
        $item = new InicioTopbar();

        $item->titulo = $request->input('txt-titulo');
        $item->correo = $request->input('txt-correo');
        $item->telefono = $request->input('txt-telefono');
        $item->ubicacion = $request->input('txt-ubicacion');

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro creado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no creado']);
        }
    }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {

            $item = InicioTopbar::find($id);

            $item->titulo = $request->input('txt-titulo');
            $item->correo = $request->input('txt-correo');
            $item->telefono = $request->input('txt-telefono');
            $item->ubicacion = $request->input('txt-ubicacion');

            $item->save();

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        $item = InicioTopbar::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


}
