<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\InicioTituloPrograma;
use App\Http\Controllers\sidebar\SidebarController;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class TituloProgramaController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.inicio.programas.titulo')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('inicio_titulo_programas as itn')
                ->select(
                    'itn.id',
                    'itn.titulo',
                    'itn.descripcion',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = InicioTituloPrograma::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // Verifica si ya existe un registro
        $existingItem = InicioTituloPrograma::first();

        if ($existingItem) {
            return response()->json(["status" => false, "mensaje" => 'Ya existe un registro. Solo puede haber un TITULO.']);
        }

        // Nuevo objeto
        $item = new InicioTituloPrograma();

        $item->titulo = $request->input('txt-titulo');
        $item->descripcion = $request->input('txt-descripcion');

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro creado exitosamente']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error al crear el registro']);
        }
    }



    public function update(Request $request, $id)
    {
        $item = InicioTituloPrograma::find($id);

        $item->titulo = $request->input('txt-titulo');
        $item->descripcion = $request->input('txt-descripcion');

        $item->save();

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {

        $item = InicioTituloPrograma::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
