<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\InicioServicios;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class ServicioController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.inicio.servicios.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('inicio_servicios as is')
                ->select(
                    'is.id',
                    'is.icono',
                    'is.descripcion',
                    'is.link',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = InicioServicios::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {

        // validar icono
        $validator = Validator::make($request->all(), [
            'txt-icono' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-icono.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-icono.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            // Nuevo objeto
            $item = new InicioServicios();
            $item->descripcion = $request->input('txt-descripcion');
            $item->link = $request->input('txt-link');
            $item->save();
            $idicono = $item->id;


            // guardar icono si existe
            if ($request->hasFile('txt-icono')) {
                $folderName =  'public/inicio/servicios/' . $idicono;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-icono');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'icono.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'icono.' . $extension;  // ruta del archivo
                $item->icono = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar icono
        $validator = Validator::make($request->all(), [
            'txt-icono' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-icono.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-icono.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);


        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = InicioServicios::find($id);
            $item->descripcion = $request->input('txt-descripcion');
            $item->link = $request->input('txt-link');

            // guardar icono si existe
            if ($request->hasFile('txt-icono')) {

                // DEBE IR DENTRO DEL IF SINO SE ELIMINARA ANTES
                $ruta = $item->icono;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $idicono = $item->id;
                // DEBE IR DENTRO DEL IF SINO SE ELIMINARA ANTES


                $folderName =  'public/inicio/servicios/' . $idicono;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-icono');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'icono.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'icono.' . $extension;  // ruta del archivo
                $item->icono = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = InicioServicios::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $icono = $item->icono;

        $file = storage_path('app/') . $icono;
        if (File::exists($file)) {
            File::delete($file);
        }

        $archivo = $item->icono;
        $file = storage_path('app/') . $archivo;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function ver_foto_icono($idvalor)
    {
        $item = InicioServicios::find($idvalor);

        $item->icono;

        if ($item->icono == "--" || $item->icono == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->icono;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
