<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Noticia;
use App\Models\Planadocente;
use App\Models\Servicio3;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class Servicio3Controller extends Controller
{

    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.servicios_complementarios.servicio3.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);

            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
            if ($request->ajax()) {

                $data = DB::table('servicio3 as s')
                ->select(
                    's.id',
                    's.area',
                    's.servicio',
                    's.descripcion',
                    's.img_descripcion',
                    's.hora_atencion',
                    's.img_atencion',
                    's.actividades',
                    's.img_actividades'
                )
                ->get();

                if($variable == "tabla") {
                    // datatable
                    return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
                } else if($variable == "div") {
                    return response()->json($data);
                } else if($variable >= 0){
                    $item = Noticia::find($variable);
                    return response()->json($item);
                }

            }

            return  response()->json([
                "status" => false,
                "mensaje" => 'Error: no se pueden cargar los datos'
            ]);
    }




    public function update(Request $request, $id)
    {
               // validar documento
               $validator = Validator::make($request->all(), [
                'txt-imagen-descripcion' => 'mimes:jpg,png,jpeg|max:5000',
                'txt-imagen-horario' => 'mimes:jpg,png,jpeg|max:5000',
                'txt-imagen-actividades' => 'mimes:jpg,png,jpeg|max:5000',
            ], [
                'txt-imagen-descripcion.mimes' => 'El archivo debe ser en formato jpg o png.',
                'txt-imagen-descripcion.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
                'txt-imagen-horario.mimes' => 'El archivo debe ser en formato jpg o png.',
                'txt-imagen-horario.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
                'txt-imagen-actividades.mimes' => 'El archivo debe ser en formato jpg o png.',
                'txt-imagen-actividades.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
            ]);

            if ($validator->fails()) {

                return response()->json([
                    "status" => 'validators',
                    "mensaje" => $validator->errors(),
                ], 422);
            } else {

                // nuevo objeto
                $item = Servicio3::find($id);;

                $item->area = $request->input('txt-area');
                $item->servicio = $request->input('txt-servicio');;
                $item->descripcion = $request->input('txt-descripcion');
                $item->hora_atencion  = $request->input('txt-horario');
                $item->actividades  = $request->input('txt-actividades');

                $idServicio = $item->id;


                if ($request->hasFile('txt-imagen-descripcion')) {
                    $folderName =  'public/servicios_complementarios/servicio3/descripcion/' . $idServicio;
                    Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-imagen-descripcion');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                    $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                    $item->img_descripcion = $filePath;
                }

                if ($request->hasFile('txt-imagen-horario')) {
                    $folderName =  'public/servicios_complementarios/servicio3/horario/' . $idServicio;
                    Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-imagen-horario');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                    $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                    $item->img_atencion = $filePath;
                }

                if ($request->hasFile('txt-imagen-actividades')) {
                    $folderName =  'public/servicios_complementarios/servicio3/actividades/' . $idServicio;
                    Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-imagen-actividades');   // obtenemos el archivo
                    $extension = $archivo->getClientOriginalExtension();
                    $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                    $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                    $item->img_actividades = $filePath;
                }

                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                }
            }

    }


    public function verImgDescripcion($idvalor)
    {
        $item = Servicio3::find($idvalor);

        $item->img_descripcion;

        if ($item->img_descripcion == "--" || $item->img_descripcion == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->img_descripcion;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }


    public function verImgAtencion($idvalor)
    {
        $item = Servicio3::find($idvalor);

        $item->img_atencion;

        if ($item->img_atencion == "--" || $item->img_atencion == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->img_atencion;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function verImgActividades($idvalor)
    {
        $item = Servicio3::find($idvalor);

        $item->img_actividades;

        if ($item->img_actividades == "--" || $item->img_actividades == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->img_actividades;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }


    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg': $contentType = 'image/jpg'; break;
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');

    }



}
