<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Noticia;
use App\Models\Planadocente;
use App\Models\Servicio1;
use App\Models\Servicio3;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class Servicio1Controller extends Controller
{
    public function combo_biblioteca(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('biblioteca as b')
                ->select(
                    'b.id as id_biblioteca',
                    'b.nombre as nombre_biblioteca',
                    'b.descripcion as descripcion_biblioteca'
                )
                ->orderBy('b.nombre')
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }

    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.servicios_complementarios.servicio1.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
            if ($request->ajax()) {

                $data = DB::table('servicio1 as s')
                ->select(
                    's.id',
                    's.area',
                    's.servicio',
                    's.descripcion',
                    's.tipo',
                    's.nombre',
                    's.descripcion_biblioteca as bdesc',
                    's.imagen_biblioteca'
                )
                ->get();

                if($variable == "tabla") {
                    // datatable
                    return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
                } else if($variable == "div") {
                    return response()->json($data);
                } else if($variable >= 0){
                    $item = Noticia::find($variable);
                    return response()->json($item);
                }

            }

            return  response()->json([
                "status" => false,
                "mensaje" => 'Error: no se pueden cargar los datos'
            ]);
    }



    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);

        } else {

            $item = Servicio1::find($id);


            $item->tipo = $request->input('txt-tipo');
            $item->descripcion_biblioteca = $request->input('txt-descripcion-biblioteca');

            $idServicio = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-foto')) {
                $ruta = $item->imagen_biblioteca;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/servicios_complementarios/servicio2/' . $idServicio;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen_biblioteca = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }

    }


    public function verFotoServicio1($id)
    {
        $item = Servicio1::find($id);

        $item->imagen_biblioteca;

        if ($item->imagen_biblioteca == "--" || $item->imagen_biblioteca == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->imagen_biblioteca;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }



    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
