<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Semestremalla;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class SemestreMallaController extends Controller
{
    public function store(Request $request)
    {
        // nuevo objeto
        $item = new Semestremalla();
        
        $item->nombre = $request->input('txt-nombre_sm');
        $item->modulo_malla_id = $request->input('txt-idmodulo_sm');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function update(Request $request)
    {
        $item = Semestremalla::find($request->input('txt-idsemestre_sm'));
        
        $item->nombre = $request->input('txt-nombre_sm');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {

        $item = Semestremalla::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
