<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Resenha;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\sidebar\SidebarController;

class ResenhaController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.reseña.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {

            $data = DB::table('resenha')->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function update(Request $request)
    {
        // Validar imagen y documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg, png y tamaño máximo de 5000 KB
            'txt-documento' => 'mimes:pdf|max:10000', // Valida que el archivo sea un PDF y no exceda los 10MB (10000 KB)
        ], [
            'txt-imagen.mimes' => 'El archivo de imagen debe ser en formato jpg, png o jpeg.',
            'txt-imagen.max' => 'El tamaño de la imagen no debe superar los 5000 KB.',
            'txt-documento.mimes' => 'El archivo debe ser un documento en formato PDF.',
            'txt-documento.max' => 'El tamaño del documento no debe superar los 10000 KB.',
        ]);


        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = Resenha::find(1);

            $item->descripcion = $request->input('descripcion');

            // guardar imagen si existe
            if ($request->hasFile('txt-imagen')) {
                $ruta = $item->imagen;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/nosotros/resenha';
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $ruta = $item->documento;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/nosotros/resenha';
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'documento.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'documento.' . $extension;  // ruta del archivo
                $item->documento = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }


    public function ver_imagen()
    {
        $item = Resenha::find(1);

        $item->imagen;

        if ($item->imagen == "--" || $item->imagen == "") {
            // return response()->json(["status" => false, "mensaje" => 'No se subio ninguna imagen']);
            return "No hay imagen";
        }

        $file = storage_path('app/') . $item->imagen;

        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);

            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf':
                    $contentType = 'application/pdf';
                    break;
                case 'png':
                    $contentType = 'image/png';
                    break;
                case 'jpg':
                case 'jpeg':
                    $contentType = 'image/jpeg';
                    break;
                default:
                    abort(404, 'Formato de archivo no admitido.');
            }

            $headers = [
                'Content-Type' => $contentType,
            ];

            $fileTitle = 'contract.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }

    public function ver_documento()
    {
        $item = Resenha::find(1);

        $item->documento;

        if ($item->documento == "--" || $item->documento == "") {
            // return response()->json(["status" => false, "mensaje" => 'No se subio ningun documento']);
            return "No hay documento";
        }

        $file = storage_path('app/') . $item->documento;

        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);

            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf':
                    $contentType = 'application/pdf';
                    break;
                case 'png':
                    $contentType = 'image/png';
                    break;
                case 'jpg':
                case 'jpeg':
                    $contentType = 'image/jpeg';
                    break;
                default:
                    abort(404, 'Formato de archivo no admitido.');
            }

            $headers = [
                'Content-Type' => $contentType,
            ];

            $fileTitle = 'contract.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }
}
