<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Programaestudio;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class ProgramaEstudioController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.programas_estudios.gestionar_pe.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index2(Request $request)
    {
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $objeto = new SidebarController();

            $sidebar = $objeto->ListmodulosSidebar();
            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;


                $programas = DB::table('programas_estudios')->get();
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.programas_estudios.secciones_pe.index', compact('programas'))->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('programas_estudios')->get();

            if($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
            } else if($variable == "div") {
                return response()->json($data);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-img_fondo' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
            'txt-img_logo' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-img_fondo.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-img_fondo.max' => 'El tamaño del archivo no debe superar los 20 MB.',
            'txt-img_logo.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-img_logo.max' => 'El tamaño del archivo no debe superar los 20 MB.',
        ]);


        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {

            // nuevo objeto
            $item = new Programaestudio();

            $item->nombre = $request->input('txt-nombre');
            $item->duracion = $request->input('txt-duracion');
            $item->modalidad = $request->input('txt-modalidad');
            $item->turno = $request->input('txt-turno');
            $item->horarios = $request->input('txt-horarios');

            $item->save();

            $id_pe = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-img_fondo')) {
                $folderName =  'public/programas_estudios/gestionar_pe/' . $id_pe;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-img_fondo');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'img_fondo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'img_fondo.' . $extension;  // ruta del archivo
                $item->img_fondo = $filePath;
            }

            // guardar documento si existe
            if ($request->hasFile('txt-img_logo')) {
                $folderName =  'public/programas_estudios/gestionar_pe/' . $id_pe;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-img_logo');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'img_logo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'img_logo.' . $extension;  // ruta del archivo
                $item->img_logo = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id_pe)
    {
       // validar documento
       $validator = Validator::make($request->all(), [
            'txt-img_fondo' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
            'txt-img_logo' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-img_fondo.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-img_fondo.max' => 'El tamaño del archivo no debe superar los 20 MB.',
            'txt-img_logo.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-img_logo.max' => 'El tamaño del archivo no debe superar los 20 MB.',
        ]);


        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {

            $item = Programaestudio::find($id_pe);

            $item->nombre = $request->input('txt-nombre');
            $item->duracion = $request->input('txt-duracion');
            $item->modalidad = $request->input('txt-modalidad');
            $item->turno = $request->input('txt-turno');
            $item->horarios = $request->input('txt-horarios');

            // guardar documento si existe
            if ($request->hasFile('txt-img_fondo')) {
                $ruta = $item->img_fondo;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/programas_estudios/gestionar_pe/' . $id_pe;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-img_fondo');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'img_fondo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'img_fondo.' . $extension;  // ruta del archivo
                $item->img_fondo = $filePath;
            }

            // guardar documento si existe
            if ($request->hasFile('txt-img_logo')) {
                $ruta = $item->img_logo;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/programas_estudios/gestionar_pe/' . $id_pe;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-img_logo');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'img_logo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'img_logo.' . $extension;  // ruta del archivo
                $item->img_logo = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }

    }


    public function destroy($id)
    {
        $item = Programaestudio::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->img_fondo;
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        $ruta = $item->img_logo;
        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }
        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function verImagenFondo($id)
    {
        $item = Programaestudio::find($id);

        $item->img_fondo;

        if ($item->img_fondo == "--" || $item->img_fondo == "") {
            // return response()->json(["status" => false, "mensaje" => 'No se subio ninguna imagen']);
            return "No hay imagen";
        }

        $file = storage_path('app/') . $item->img_fondo;

        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);

            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf': $contentType = 'application/pdf'; break;
                case 'png': $contentType = 'image/png'; break;
                case 'jpg':
                case 'jpeg': $contentType = 'image/jpeg'; break;
                default: abort(404, 'Formato de archivo no admitido.');
            }

            $headers = [
                'Content-Type' => $contentType,
            ];

            $fileTitle = 'contract.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function verImagenLogo($id)
    {
        $item = Programaestudio::find($id);

        $item->img_logo;

        if ($item->img_logo == "--" || $item->img_logo == "") {
            return "No hay imagen";
        }

        $file = storage_path('app/') . $item->img_logo;

        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);

            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf': $contentType = 'application/pdf'; break;
                case 'png': $contentType = 'image/png'; break;
                case 'jpg':
                case 'jpeg': $contentType = 'image/jpeg'; break;
                default: abort(404, 'Formato de archivo no admitido.');
            }

            $headers = [
                'Content-Type' => $contentType,
            ];

            $fileTitle = 'contract.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }
}
