<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Presentacionimagen;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class PresentacionImagenController extends Controller
{
    public function list(Request $request)
    {

        if ($request->ajax()) {
            $data = DB::table('presentacion_imagenes')->where('presentacion_id', 1)->get();

            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function list2(Request $request)
    {

        if ($request->ajax()) {
            $data = DB::table('presentacion_imagenes')->where('presentacion_id', 1)->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ], 422);

        } else {

            // nuevo objeto
            $item = new Presentacionimagen();

            $item->presentacion_id = 1;
            $item->imagen = "--";
            $item->save();

            $idimagen = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-imagen')) {
                $folderName =  'public/nosotros/presentacion/imagen_carrusel/' . $idimagen;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ], 422);

        } else {

            $item = Presentacionimagen::find($id);

            // guardar documento si existe
            if ($request->hasFile('txt-imagen')) {
                $idimagen = $item->id;
                $ruta = $item->imagen;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/nosotros/presentacion/imagen_carrusel/' . $idimagen;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }

    }


    public function ver_imagen($id)
    {
        $item = Presentacionimagen::find($id);

        $item->imagen;

        if ($item->imagen == "--" || $item->imagen == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
        }

        $file = storage_path('app/') . $item->imagen;

        if (file_exists($file)) {
            return $this->funcion_verImagen($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
        }
    }

    public function funcion_verImagen($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
