<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Presentacion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

use App\Http\Controllers\sidebar\SidebarController;
class PresentacionController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            
            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.presentacion.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            
            $data = DB::table('presentacion')->get();
            
            return response()->json($data);
        }
        
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
            'txt-foto_director' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
            'txt-foto_director.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto_director.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);

        } else {

            $item = Presentacion::find($id);

            $item->titulo = $request->input('txt-titulo');
            $item->nombre_director = $request->input('txt-nombre_director');
            $item->palabras_director = $request->input('palabras_director');

            // guardar documento si existe
            if ($request->hasFile('txt-foto_director')) {
                $ruta = $item->foto_director;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }
                
                $folderName =  'public/nosotros/presentacion';
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto_director');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'foto_director.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'foto_director.' . $extension;  // ruta del archivo
                $item->foto_director = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
        
    }


    public function ver_imagen()
    {
        $item = Presentacion::find(1);
        
        $item->imagen;
        
        if ($item->imagen == "--" || $item->imagen == "") {
            // return response()->json(["status" => false, "mensaje" => 'No se subio ninguna imagen']);
            return "No hay imagen";
        }

        $file = storage_path('app/') . $item->imagen;
        
        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);
            
            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf': $contentType = 'application/pdf'; break;
                case 'png': $contentType = 'image/png'; break;
                case 'jpg':
                case 'jpeg': $contentType = 'image/jpeg'; break;
                default: abort(404, 'Formato de archivo no admitido.');
            }

            $headers = [
                'Content-Type' => $contentType,
            ];
            
            $fileTitle = 'contract.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }


    public function ver_foto_director()
    {
        $item = Presentacion::find(1);
        
        $item->foto_director;
        
        if ($item->foto_director == "--" || $item->foto_director == "") {
            // return response()->json(["status" => false, "mensaje" => 'No se subio ninguna imagen']);
            return "No hay imagen";
        }

        $file = storage_path('app/') . $item->foto_director;
        
        if (file_exists($file)) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);
            
            // Verificar la extensión y establecer el tipo de contenido correspondiente
            switch ($extension) {
                case 'pdf': $contentType = 'application/pdf'; break;
                case 'png': $contentType = 'image/png'; break;
                case 'jpg':
                case 'jpeg': $contentType = 'image/jpeg'; break;
                default: abort(404, 'Formato de archivo no admitido.');
            }
            
            $headers = [
                'Content-Type' => $contentType,
            ];
            
            $fileTitle = 'contract.' . $extension;
            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            abort(404, 'Archivo no encontrado!');
        }
    }
}
