<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Planadocente;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class PlanaDocenteController extends Controller
{

    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                // Obtén todos los programas de estudio
                $programas = DB::table('programas_estudios')->get();

                return view('admin.nosotros.plana_docente.index', compact('programas'))->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);

            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        $idprogram = $request->input('idprogram');

        if ($request->ajax()) {

            $data = DB::table('plana_docente as pd')
            ->select(
                'pd.id',
                'pd.foto',
                'pd.nombre',
                'pd.cargo',
                'pd.celular',
                'pd.correo',
                'pd.estado',
            )
            ->where('pd.programa_estudio_id', $idprogram)
            ->orderBy('pd.nombre');

            // if($idprogram != "all") {
            //     $data = $data->where('pd.programa_estudio_id', $idprogram);
            // }

            $data = $data->get();

            if($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
            } else if($variable == "div") {
                return response()->json($data);
            }

        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {

            // nuevo objeto
            $item = new Planadocente();

            $item->nombre = $request->input('txt-nombre');
            $item->programa_estudio_id = $request->input('txt-programa_estudio_id');
            $item->cargo = $request->input('txt-cargo');
            $item->celular  = $request->input('txt-celular');
            $item->correo = $request->input('txt-correo');

            $item->save();

            $idpd = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-foto')) {
                $folderName =  'public/nosotros/plana_docente/docente/' . $idpd;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'foto.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'foto.' . $extension;  // ruta del archivo
                $item->foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {

            $item = Planadocente::find($id);

            $item->nombre = $request->input('txt-nombre');;
            $item->cargo = $request->input('txt-cargo');
            $item->celular = $request->input('txt-celular');
            $item->correo = $request->input('txt-correo');

            $item->save();

            $idpd = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-foto')) {
                $ruta = $item->foto;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/nosotros/plana_docente/docente/' . $idpd;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'foto.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'foto.' . $extension;  // ruta del archivo
                $item->foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = Planadocente::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->foto;

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function verFotoPD($id)
    {
        $item = Planadocente::find($id);

        $item->foto;

        if ($item->foto == "--" || $item->foto == "") {
            $file = storage_path('app/public/nosotros/plana_jerarquica/personaUser.png');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->foto;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/nosotros/plana_jerarquica/personaUser.png');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
