<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\PersonalAdministrativo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class PersonalAdministrativoController extends Controller
{

    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.personal_administrativo.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('personal_administrativo as pa')
            ->select(
                'pa.id',
                'pa.nombre',
                'pa.cargo',
                'pa.lugar',
                'pa.imagen',
            )
            ->get();

            if($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
            } else if($variable == "div") {
                return response()->json($data);
            }

        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // Validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg/png y tamaño máximo de 5MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        }

        // Crear nuevo objeto
        $item = new PersonalAdministrativo();
        $item->nombre = $request->input('txt-nombre');
        $item->cargo = $request->input('txt-cargo');
        $item->lugar = $request->input('txt-lugar');

        // Guardar documento si existe
        if ($request->hasFile('txt-foto')) {
            $folderName = 'public/nosotros/personal_administrativo/' . $item->id;
            $archivo = $request->file('txt-foto');
            $extension = $archivo->getClientOriginalExtension();
            $filePath = $folderName . '/foto.' . $extension;
            $archivo->storeAs($folderName, 'foto.' . $extension); // Guardar el archivo
            $item->imagen = $filePath;
            $item->save(); // Guardar nuevamente con la ruta de la imagen actualizada
        }

        return response()->json([
            "status" => true,
            "mensaje" => 'Registro creado'
        ]);
    }




    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {

            $item = PersonalAdministrativo::find($id);

            $item->nombre = $request->input('txt-nombre');;
            $item->cargo = $request->input('txt-cargo');
            $item->lugar = $request->input('txt-lugar');

            $idpj = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-foto')) {
                $ruta = $item->foto;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/nosotros/personal_administrativo/' . $idpj;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }

    }


    public function destroy($id)
    {

        $item = PersonalAdministrativo::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->foto;

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }



    public function verFotoPA($id)
    {
        $item = PersonalAdministrativo::find($id);

        $item->imagen;

        if ($item->imagen == "--" || $item->imagen == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->imagen;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
