<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Programaestudio;
use App\Models\Perfilegreso;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class PerfilegresoController extends Controller
{

    public function list(Request $request, $idprogram)
    {
        if ($request->ajax()) {

            $data = DB::table('pe_perfil_egreso')->where('programa_estudio_id', $idprogram)->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function update(Request $request, $id_pe)
    {

            $programa = Programaestudio::find($id_pe);
            $item = Perfilegreso::where("programa_estudio_id", $programa->id)->first();

            $item->descripcion = $request->input('txt-perfil_egresado');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
    }
}
