<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Organigrama;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\sidebar\SidebarController;

class OrganigramaController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.organigrama.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function update(Request $request)
    {
        // Validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:pdf|max:5000', // Valida pdf y tamaño máximo de 5 MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser en formato PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 5 MB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators',
                "mensaje" => "El archivo no es válido.",
            ], 422);
        } else {
            // Comprobar si el registro existe, si no, crear uno nuevo
            $item = Organigrama::first(); // O usa Organigrama::find(1) si necesitas específicamente el primer registro
            if (!$item) {
                // Si no existe, crear un nuevo registro
                $item = new Organigrama();
            }

            // Guardar el archivo si se ha subido
            if ($request->hasFile('txt-documento')) {
                $folderName = 'public/nosotros/organigrama_institucional';
                Storage::disk('local')->makeDirectory($folderName); // Crear la carpeta si no existe
                $archivo = $request->file('txt-documento'); // Obtener el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'Organigrama_Institucional.' . $extension); // Guardar archivo

                // Establecer la ruta del archivo en el objeto
                $filePath = $folderName . '/' . 'Organigrama_Institucional.' . $extension;
                $item->documento = $filePath; // Asignar la ruta al campo documento
            }

            // Guardar el registro
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado correctamente.']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Error al actualizar el registro.']);
            }
        }
    }


    public function verOrganigramaInstitucional()
    {
        $item = Organigrama::find(1);

        $item->documento;

        if ($item->documento == "--" || $item->documento == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->documento;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }


    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
                $contentType = 'image/jpg';
                break;
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
