<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Noticia;
use App\Models\Planadocente;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class NoticiaController extends Controller
{

    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.noticias.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);

            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
            if ($request->ajax()) {

                $data = DB::table('noticias as n')
                ->select(
                    'n.id',
                    'n.imagen',
                    'n.fecha',
                    'n.titulo',
                    'n.descripcion',
                    'n.archivo',
                    'n.estado',
                )
                ->get();

                if($variable == "tabla") {
                    // datatable
                    return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
                } else if($variable == "div") {
                    return response()->json($data);
                } else if($variable >= 0){
                    $item = Noticia::find($variable);
                    return response()->json($item);
                }

            }

            return  response()->json([
                "status" => false,
                "mensaje" => 'Error: no se pueden cargar los datos'
            ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
            'txt-archivo' => 'mimes:pdf|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
            'txt-archivo.mimes' => 'El archivo debe ser en formato PDF.',
            'txt-archivo.max' => 'El tamaño del archivo no debe superar los 5 MB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else{

            // nuevo objeto
            $item = new Noticia();

            $item->titulo = $request->input('txt-titulo');
            $item->descripcion = $request->input('txt-descripcion');;
            $item->fecha = $request->input('txt-fecha');
            $item->archivo  = $request->input('txt-archivo');

            $item->save();

            $idnoticia = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-imagen')) {
                $folderName =  'public/noticias/imagen/' . $idnoticia;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }
            if ($request->hasFile('txt-archivo')) {
                $folderName =  'public/noticias/archivo/'. $idnoticia;;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-archivo');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'archivo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'archivo.' . $extension;  // ruta del archivo
                $item->archivo = $filePath;
            }
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
            'txt-archivo' => 'mimes:pdf|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
            'txt-archivo.mimes' => 'El archivo debe ser en formato PDF.',
            'txt-archivo.max' => 'El tamaño del archivo no debe superar los 5 MB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = Noticia::find($id);

            $item->titulo = $request->input('txt-titulo');
            $item->descripcion = $request->input('txt-descripcion');;
            $item->fecha = $request->input('txt-fecha');
            $item->archivo  = $request->input('txt-archivo');

            $item->save();

            $idnoticia = $item->id;

           // guardar documento si existe
            if ($request->hasFile('txt-imagen')) {
                $folderName =  'public/noticias/imagen/' . $idnoticia;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }
            if ($request->hasFile('txt-archivo')) {
                $folderName =  'public/noticias/archivo/'. $idnoticia;;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-archivo');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'archivo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'archivo.' . $extension;  // ruta del archivo
                $item->archivo = $filePath;
            }
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }

    }


    public function destroy($id)
    {

        $item = Noticia::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $imagen = $item->imagen;

        $file = storage_path('app/') . $imagen;
        if (File::exists($file)) {
            File::delete($file);
        }

        $archivo = $item->imagen;
        $file = storage_path('app/') . $archivo;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function verFotoNoticia($idvalor)
    {
        $item = Noticia::find($idvalor);

        $item->imagen;

        if ($item->imagen == "--" || $item->imagen == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->imagen;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }




    public function verArchivoNoticia($idvalor)
    {
        $item = Noticia::find($idvalor);

        $item->archivo;

        if ($item->archivo == "--" || $item->archivo == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->archivo;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }



}
