<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Mision;
use App\Models\Vision;
use App\Models\Valor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\sidebar\SidebarController;

class MvvController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.mision_vision_valores.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list_mv(Request $request)
    {
        if ($request->ajax()) {

            $data = DB::table('mision as mi')
                ->crossJoin('vision as vi')
                ->select(
                    'mi.id as idmision',
                    'mi.descripcion as mision',
                    'vi.id as idvision',
                    'vi.descripcion as vision'
                )
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }

    public function list_valores(Request $request)
    {
        if ($request->ajax()) {

            $data = DB::table('valores as va')
                ->select(
                    'va.id as idvalor',
                    'va.titulo as va_titulo',
                    'va.imagen as va_imagen',
                    'va.descripcion as va_descripcion'
                )
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function update(Request $request)
    {
        // Verificamos si ya existen los registros de Misión y Visión
        $mision = Mision::find(1);
        $vision = Vision::find(1);

        // Si no existen, creamos los registros con ID = 1
        if (!$mision) {
            $mision = new Mision();
        }

        if (!$vision) {
            $vision = new Vision();
        }

        // Asignamos los valores de los inputs a los modelos
        $mision->descripcion = $request->input('txt-mision');
        $vision->descripcion = $request->input('txt-vision');

        // Aseguramos que solo exista un registro para Misión y Visión
        if ($mision->id == 1 && $vision->id == 1) {
            // Si ambos registros tienen el ID = 1, actualizamos los registros
            if ($mision->save() && $vision->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registros actualizados correctamente']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'No se pudieron actualizar los registros']);
            }
        } else {
            // Si ya hay registros de misión y visión con otros ID, se lanzaría un error.
            return response()->json(["status" => false, "mensaje" => 'Solo debe existir un registro para Misión y Visión']);
        }
    }

    public function storeValor(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000',
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            // nuevo objeto
            $item = new Valor();

            $item->titulo = $request->input('txt-titulo');;
            $item->descripcion = $request->input('txt-descripcion');

            $item->save();

            $idvalor = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-imagen')) {
                $folderName =  'public/nosotros/mision_vision_valores/valores/' . $idvalor;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function updateValor(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = Valor::find($id);

            $item->titulo = $request->input('txt-titulo');;
            $item->descripcion = $request->input('txt-descripcion');;
            // $item->imagen;

            $idvalor = $item->id;
            $ruta = $item->imagen;

            // guardar documento si existe
            if ($request->hasFile('txt-imagen')) {

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/nosotros/mision_vision_valores/valores/' . $idvalor;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = Valor::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->imagen;

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ver_imagen_valor($idvalor)
    {
        $item = Valor::find($idvalor);

        $item->imagen;

        if ($item->imagen == "--" || $item->imagen == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
        }

        $file = storage_path('app/') . $item->imagen;

        if (file_exists($file)) {
            return $this->funcion_verImagen($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verImagen($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
