<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Modulomalla;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class ModuloMallaController extends Controller
{
    public function store(Request $request)
    {
        // nuevo objeto
        $item = new Modulomalla();
        
        $item->nombre = $request->input('txt-nombre_mm');
        $item->efsrt = $request->input('txt-efsrt_mm');
        $item->programa_estudio_id = $request->input('txt-idpe_mm');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function update(Request $request)
    {       
        $item = Modulomalla::find($request->input('txt-idmodulo_mm'));
        
        $item->nombre = $request->input('txt-nombre_mm');
        $item->efsrt = $request->input('txt-efsrt_mm');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {
        
        $item = Modulomalla::find($id);
        
        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        
        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
