<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Mallacurricular;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class MallaCurricularController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.mision_vision_valores.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idprograma = $request->input('idprogram');

            $data = DB::table('pe_modulos_malla as mm')
                ->leftJoin('pe_semestres_malla as sm', 'sm.modulo_malla_id', '=', 'mm.id')
                ->leftJoin('pe_cursos_malla as cm', 'cm.semestre_malla_id', '=', 'sm.id')
                ->select(
                    'mm.id as idmodulo',
                    'mm.nombre as modulo',
                    'mm.efsrt',
                    'sm.id as idsemestre',
                    DB::raw('COALESCE(sm.nombre, "-") as semestre'),
                    'cm.id as idcurso',
                    'cm.nombre as curso',
                    'cm.creditos',
                    'cm.horas'
                )
                ->where('mm.programa_estudio_id', $idprograma)
                ->orderBy('mm.nombre')
                ->get();

            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }
}
