<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Convenio;
use App\Models\Linkinstitucional;
use App\Models\Noticia;
use App\Models\Planadocente;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class LinksController extends Controller
{

    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.link_institucionales.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);

            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {

        if ($request->ajax()) {

            $data = DB::table('links_institucionales as li')
            ->select(
                'li.id',
                'li.nombre',
                'li.enlace'
            )
            ->get();

            if($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
            } else if($variable == "div") {
                return response()->json($data);
            } else if($variable >= 0){
                $item = Noticia::find($variable);
                return response()->json($item);
            }

        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
            $item = new Linkinstitucional();

            $item->nombre = $request->input('txt-nombre');
            $item->enlace = $request->input('txt-enlace');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro añadido']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no añadido']);
            }
    }


    public function update(Request $request, $id)
    {


        $item = Linkinstitucional::find($id);

        $item->nombre = $request->input('txt-nombre');
        $item->enlace = $request->input('txt-enlace');

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }

    }


    public function destroy($id)
    {

        $item = Linkinstitucional::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
