<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Capacitacion;
use App\Models\Estadistica;
use App\Models\Tupa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class EstadisticasController extends Controller
{


    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.transparencia.estadisticas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);

            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function combo_tema_estadistico(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('tema_estadistico as te')
                ->select(
                    'te.id as id_tema',
                    'te.tema as nombre_tema'
                )
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }

    public function combo_programas(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('programas_estudios as pe')
                ->select(
                    'pe.id as id_programa',
                    'pe.nombre as nombre_programa'
                )
                ->orderBy('pe.nombre')
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function combo_anio_estadistico(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('anio_estadistico as ae')
                ->select(
                    'ae.id as id_anio',
                    'ae.anio as nombre_anio'
                )
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }

    public function list(Request $request, $variable)
    {
        $idtema = $request->input('idtema');

        if ($request->ajax()) {
            $estadisticas = DB::table('estadisticas as e')
                ->select(
                    'e.programa_id as programa_id',
                    'e.tema_estadistico_id as tema_id',
                    'pe.nombre as programa',
                    'e.anio_estadistico_id as anio',
                    'e.cantidad'
                )
                ->join('programas_estudios as pe', 'pe.id', '=', 'e.programa_id')
                ->where('e.tema_estadistico_id', $idtema)
                ->get();
    
            $datosTabla = [];
            foreach ($estadisticas as $estadistica) {
                $programa = $estadistica->programa;
                $anioMapping = [
                    1 => 'cantidad2021',
                    2 => 'cantidad2022',
                    3 => 'cantidad2023',
                    4 => 'cantidad2024',
                    5 => 'cantidad2025',
                ];
                // Inicializar el array para el programa si no existe
                if (!isset($datosTabla[$programa])) {
                    $datosTabla[$programa] = [
                        'nombre' => $programa,
                        'programa_id' => $estadistica->programa_id,
                        'tema_id' => $estadistica->tema_id,
                        'cantidad2021' => 0,
                        'cantidad2022' => 0,
                        'cantidad2023' => 0,
                        'cantidad2024' => 0,
                        'cantidad2025' => 0,
                    ];
                }
                $anioKey = $anioMapping[$estadistica->anio] ?? null; // Mapeo del año
                if ($anioKey && isset($datosTabla[$programa][$anioKey])) {
                    $datosTabla[$programa][$anioKey] = $estadistica->cantidad;
                }
            }
    
            $datasets = [];
            foreach ($datosTabla as $dato) {
                $datasets[] = [
                    'label' => $dato['nombre'],
                    'data' => [
                        $dato['cantidad2021'],
                        $dato['cantidad2022'],
                        $dato['cantidad2023'],
                        $dato['cantidad2024'],
                        $dato['cantidad2025'],
                    ],
                    'backgroundColor' => 'rgba(255, 99, 132, 0.2)', // Puedes personalizar los colores
                    'borderColor' => 'rgba(255, 99, 132, 1)',
                    'borderWidth' => 1,
                ];
            }

            if($variable == "tabla") {
                // datatable
                return DataTables::of($datosTabla)
                ->addIndexColumn()
                ->make(true);
            } else if($variable == "div") {
                return response()->json($datasets);
            }
            
        }
        
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {

        // nuevo objeto
        $item = new Estadistica();
        $item->programa_id = $request->input('txt-programa');
        $item->anio_estadistico_id = $request->input('txt-anio');
        $item->tema_estadistico_id = $request->input('txt-tema');
        $item->cantidad = $request->input('txt-cantidad');

        $item->save();

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
        
    }


    public function update(Request $request)
    {
        $data = $request->validate([
            'txt-tema-form' => 'required|exists:estadisticas,tema_estadistico_id',
            'txt-programa-form' => 'required|exists:estadisticas,programa_id',
            'txt-anio-form' => 'required|exists:estadisticas,anio_estadistico_id',
            'txt-cantidad-form' => 'required|numeric',
        ]);

        // Buscar el registro
            $item = Estadistica::where('tema_estadistico_id',  $request->input('txt-tema-form'))
            ->where('programa_id', $request->input('txt-programa-form'))
            ->where('anio_estadistico_id', $request->input('txt-anio-form'))
            ->first();

        // Verificar si se encontró el registro
        if ($item) {
        // Actualizar la cantidad
        $item->cantidad = $request->input('txt-cantidad-form');
        $item->save();

        return response()->json(['status' => true, 'mensaje' => 'Actualización exitosa.']);
        } else {
        return response()->json(['status' => false, 'mensaje' => 'Registro no encontrado.']);
        }
    }

}
