<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Egresado;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class EgresadoController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.mision_vision_valores.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idprograma = $request->input('idprogram');

            $data = DB::table('pe_egresado as eg')
            ->select(
                'eg.id as id',
                'eg.nombre as nombre',
                'eg.descripcion as descripcion',
                'eg.foto as foto',
                'eg.programa_estudio_id as programa_estudio_id'
            )
            ->where('eg.programa_estudio_id', $idprograma)
            ->get();


            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto_eg' => 'mimes:jpg,png,jpeg|max:20000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto_eg.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto_eg.max' => 'El tamaño del archivo no debe superar los 20 MB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else  {

            // nuevo objeto
            $item = new Egresado();

            $item->nombre = $request->input('txt-nombre_eg');
            $item->descripcion = $request->input('txt-descripcion_eg');
            $item->programa_estudio_id = $request->input('txt-programa_estudio_id_eg');

            $item->save();

            $idegresado = $item->id;
            $idprograma = $item->programa_estudio_id;

            // guardar documento si existe
            if ($request->hasFile('txt-foto_eg')) {
                $folderName =  'public/programas_estudios/gestionar_pe/'. $idprograma . '/' . 'egresado/' . $idegresado;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto_eg');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto_eg' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto_eg.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto_eg.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else  {

            $item = Egresado::find($request->input('txt-idegresado'));

            $item->nombre = $request->input('txt-nombre_eg');
            $item->descripcion = $request->input('txt-descripcion_eg');

            $idegresado = $item->id;
            $idprograma = $item->programa_estudio_id;

            // guardar documento si existe
            if ($request->hasFile('txt-foto_eg')) {
                $ruta = $item->foto;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/programas_estudios/gestionar_pe/'. $idprograma . '/' . 'egresado/' . $idegresado;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto_eg');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }

    }


    public function destroy($id)
    {

        $item = Egresado::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->foto;

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function verEgresadoFoto($idegresado)
    {
        $item = Egresado::find($idegresado);

        $item->foto;

        if ($item->foto == "--" || $item->foto == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
        }

        $file = storage_path('app/') . $item->foto;

        if (file_exists($file)) {
            return $this->funcion_verImagen($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }


    public function funcion_verImagen($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
