<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Efsrt;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class EfsrtController extends Controller
{
    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idprograma = $request->input('idprogram');
            
            $data = DB::table('pe_efsrt as ef')
            ->select(
                'ef.id as id',
                'ef.descripcion as descripcion',
                'ef.programa_estudio_id as programa_estudio_id'
            )
            ->where('ef.programa_estudio_id', $idprograma)
            ->get();
            
            
            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }
        
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // nuevo objeto
        $item = new Efsrt();
        
        $item->descripcion = $request->input('txt-descripcion_efsrt');
        $item->programa_estudio_id = $request->input('txt-programa_estudio_id_efsrt');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function update(Request $request)
    {       
        $item = Efsrt::find($request->input('txt-idefsrt'));
        
        $item->descripcion = $request->input('txt-descripcion_efsrt');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {

        $item = Efsrt::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    //
    
}
