<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Documentogestion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class DocumentoGestionController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.transparencia.documentos_gestion.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('documentos_gestion as dg')
                ->select(
                    'dg.id',
                    'dg.nombre',
                    'dg.documento',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = Documentogestion::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:jpg,png,jpeg,pdf|max:20000',
        ], [
            'txt-documento.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 20000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            // nuevo objeto
            $item = new Documentogestion();

            $item->nombre = $request->input('txt-nombre');

            $item->save();

            $iddocumento = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/documentos_gestion/' . $iddocumento;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'documento.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'documento.' . $extension;  // ruta del archivo
                $item->documento = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:jpg,png,jpeg,pdf|max:20000',
        ], [
            'txt-documento.mimes' => 'El archivo debe ser en formato imagen o pdf.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 20000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = Documentogestion::find($id);

            $item->nombre = $request->input('txt-nombre');

            $item->save();

            $iddocumento = $item->id;

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $ruta = $item->imagen;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/documentos_gestion/' . $iddocumento;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'documento.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'documento.' . $extension;  // ruta del archivo
                $item->documento = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = Documentogestion::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $documento = $item->documento;

        $file = storage_path('app/') . $documento;
        if (File::exists($file)) {
            File::delete($file);
        }

        $archivo = $item->documento;
        $file = storage_path('app/') . $archivo;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function ver_documento_gestion($idvalor)
    {
        $item = Documentogestion::find($idvalor);

        $item->documento;

        if ($item->documento == "--" || $item->documento == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->documento;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
