<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Datoslaborales;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class DatosLaboralesController extends Controller
{

    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;

                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.plana_docente.datos_laborales')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function combo_programas(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('programas_estudios as pe')
                ->select(
                    'pe.id as idprograma',
                    'pe.nombre as nombre_programa'
                )
                ->orderBy('pe.nombre')
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function combo_docentes(Request $request, $idprograma)
    {
        if ($request->ajax()) {
            $data = DB::table('plana_docente as pd')
                ->select(
                    'pd.id as iddocente',
                    'pd.nombre as nombre_docente'
                )
                // ->orderBy('pd.nombre')
                ->where('pd.programa_estudio_id', $idprograma)
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }



    public function list(Request $request, $variable)
    {
        $idplanadocente = $request->input('idplanadocente');

        if ($request->ajax()) {

            $data = DB::table('datos_laborales as dl')
            ->select(
                'dl.id',
                'dl.plana_docente_id',
                'dl.institucion',
                'dl.cargo',
                DB::raw('CONCAT(TIMESTAMPDIFF(YEAR, dl.inicio, dl.termino), " años ") AS experiencia'),
                'dl.inicio',
                'dl.termino',
                DB::raw('
                    CONCAT(
                        TIMESTAMPDIFF(YEAR, dl.inicio, dl.termino), " años ",
                        MOD(TIMESTAMPDIFF(MONTH, dl.inicio, dl.termino), 12), " meses"
                    ) AS tiempocargo
                ')
            )
            ->where('dl.plana_docente_id', $idplanadocente);

            $data = $data->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {

            // nuevo objeto
            $item = new Datoslaborales();

            $item->institucion = $request->input('txt-institucion');
            $item->plana_docente_id = $request->input('txt-plana_docente_id');
            $item->cargo = $request->input('txt-cargo');
            $item->inicio = $request->input('txt-inicio');
            $item->termino = $request->input('txt-termino');

            $item->save();


            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {

            $item = Datoslaborales::find($id);

            $item->institucion = $request->input('txt-institucion');
            $item->plana_docente_id = $request->input('txt-plana_docente_id');
            $item->cargo = $request->input('txt-cargo');
            $item->inicio = $request->input('txt-inicio');
            $item->termino = $request->input('txt-termino');

            $item->save();

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = Datoslaborales::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
