<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\DatosAcademicos;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class DatosAcademicosController extends Controller
{

    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;

                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.plana_docente.datos_academicos')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function combo_programas(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('programas_estudios as pe')
                ->select(
                    'pe.id as idprograma',
                    'pe.nombre as nombre_programa'
                )
                ->orderBy('pe.nombre')
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function combo_docentes(Request $request, $idprograma)
    {
        if ($request->ajax()) {
            $data = DB::table('plana_docente as pd')
                ->select(
                    'pd.id as iddocente',
                    'pd.nombre as nombre_docente'
                )
                // ->orderBy('pd.nombre')
                ->where('pd.programa_estudio_id', $idprograma)
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }



    public function list(Request $request, $variable)
    {
        $idplanadocente = $request->input('idplanadocente');

        if ($request->ajax()) {

            $data = DB::table('datos_academicos as da')
                ->select(
                    'da.id',
                    'da.plana_docente_id',
                    'da.grado',
                    'da.situacion_academica',
                    'da.especialidad',
                    'da.institucion',
                    'da.fecha_emision',
                    'da.registro',
                )
                ->where('da.plana_docente_id', $idplanadocente);

            $data = $data->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {

            // nuevo objeto
            $item = new DatosAcademicos();

            $item->grado = $request->input('txt-grado');
            $item->plana_docente_id = $request->input('txt-plana_docente_id');
            $item->situacion_academica = $request->input('txt-situacion_academica');
            $item->especialidad = $request->input('txt-especialidad');
            $item->institucion = $request->input('txt-institucion');
            $item->fecha_emision = $request->input('txt-fecha_emision');
            $item->registro = $request->input('txt-registro');

            $item->save();


            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {

            $item = DatosAcademicos::find($id);

            $item->grado = $request->input('txt-grado');
            $item->plana_docente_id = $request->input('txt-plana_docente_id');
            $item->situacion_academica = $request->input('txt-situacion_academica');
            $item->especialidad = $request->input('txt-especialidad');
            $item->institucion = $request->input('txt-institucion');
            $item->fecha_emision = $request->input('txt-fecha_emision');
            $item->registro = $request->input('txt-registro');

            $item->save();

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = DatosAcademicos::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
