<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Cursomalla;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class CursoMallaController extends Controller
{
    public function store(Request $request)
    {
        // nuevo objeto
        $item = new Cursomalla();
        
        $item->nombre = $request->input('txt-nombre_cm');
        $item->creditos = $request->input('txt-creditos_cm');
        $item->horas = $request->input('txt-horas_cm');
        $item->semestre_malla_id = $request->input('txt-idsemestre_cm');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function update(Request $request)
    {       
        $item = Cursomalla::find($request->input('txt-idcurso_cm'));
        
        $item->nombre = $request->input('txt-nombre_cm');
        $item->creditos = $request->input('txt-creditos_cm');
        $item->horas = $request->input('txt-horas_cm');
        
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {
        
        $item = Cursomalla::find($id);
        
        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        
        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
