<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Programaestudio;
use App\Models\Coordinadorgeneral;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class CoordinadorGeneralController extends Controller
{

    public function list(Request $request, $idprogram)
    {
        if ($request->ajax()) {

            $data = DB::table('pe_coordinador')->where('programa_estudio_id', $idprogram)->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function update(Request $request, $id_pe)
    {
           // validar documento
        $validator = Validator::make($request->all(), [
            'txt-img_fondo_coordinador' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
            'txt-img_foto_coordinador' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-img_fondo_coordinador.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-img_fondo_coordinador.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
            'txt-img_foto_coordinador.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-img_foto_coordinador.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {


            $programa = Programaestudio::find($id_pe);
            $item = Coordinadorgeneral::find($programa->id);

            $item->nombre = $request->input('txt-nombre_coordinador');
            $item->cargo = $request->input('txt-cargo_coordinador');
            $item->descripcion = $request->input('txt-descripcion_coordinador');

            // guardar documento si existe
            if ($request->hasFile('txt-img_fondo_coordinador')) {
                $ruta = $item->img_fondo;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/programas_estudios/gestionar_pe/'. $id_pe . '/' . 'coordinador';
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-img_fondo_coordinador');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'img_fondo.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'img_fondo.' . $extension;  // ruta del archivo
                $item->img_fondo = $filePath;
            }

            // guardar documento si existe
            if ($request->hasFile('txt-img_foto_coordinador')) {
                $ruta = $item->img_foto;
                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/programas_estudios/gestionar_pe/'. $id_pe . '/' . 'coordinador';
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-img_foto_coordinador');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'img_foto.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'img_foto.' . $extension;  // ruta del archivo
                $item->img_foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }

    public function verCoordinadorFondo($id)
    {
        $item = Coordinadorgeneral::find($id);

        $item->img_fondo;

        if ($item->img_fondo == "--" || $item->img_fondo == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->img_fondo;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function verCoordinadorFoto($id)
    {
        $item = Coordinadorgeneral::find($id);

        $item->img_foto;

        if ($item->img_foto == "--" || $item->img_foto == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->img_foto;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
