<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Noticia;
use App\Models\Planadocente;
use App\Models\Colores;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class ColoresController extends Controller
{

    public function list(Request $request, $variable)
    {
            if ($request->ajax()) {

                $data = DB::table('colores as c')
                ->select(
                    'c.id',
                    'c.elemento',
                    'c.codigoHex'
                )
                ->get();


                if($variable == "all") {
                    return response()->json($data);
                } else  {
                    $item = Colores::find($variable);
                    return response()->json($item);
                }

            }

            return  response()->json([
                "status" => false,
                "mensaje" => 'Error: no se pueden cargar los datos'
            ]);
    }



    public function update(Request $request, $id)
    {

            $item = Colores::find($id);

            $item->codigoHex = $request->input('txt-valor-color');
            $item->save();
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }


    }



}
