<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\InicioCarrusel;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class CarruselController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.inicio.carrusel.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('inicio_carrusel as ic')
                ->select(
                    'ic.id',
                    'ic.foto',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = InicioCarrusel::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // Validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 5000 KB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        }

        // Verificar si ya hay 6 registros
        $existingCount = InicioCarrusel::count(); // Cuenta los registros existentes
        if ($existingCount >= 6) {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede ingresar más de 6 carruseles.',
            ], 422);
        } else {
            // nuevo objeto
            $item = new InicioCarrusel();

            $item->save();

            $idfoto = $item->id;

            // guardar foto si existe
            if ($request->hasFile('txt-foto')) {
                $folderName =  'public/inicio/carrusel/' . $idfoto;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'foto.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'foto.' . $extension;  // ruta del archivo
                $item->foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }



    public function update(Request $request, $id)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-foto' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-foto.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-foto.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = InicioCarrusel::find($id);

            $item->save();


            // guardar foto si existe
            if ($request->hasFile('txt-foto')) {

                // DEBE IR DENTRO DEL IF SINO SE ELIMINARA ANTES
                $ruta = $item->foto;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $idfoto = $item->id;
                // DEBE IR DENTRO DEL IF SINO SE ELIMINARA ANTES

                $folderName =  'public/inicio/carrusel/' . $idfoto;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-foto');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'foto.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'foto.' . $extension;  // ruta del archivo
                $item->foto = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = InicioCarrusel::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $foto = $item->foto;

        $file = storage_path('app/') . $foto;
        if (File::exists($file)) {
            File::delete($file);
        }

        $archivo = $item->foto;
        $file = storage_path('app/') . $archivo;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }



    public function ver_foto_carrusel($idvalor)
    {
        $item = InicioCarrusel::find($idvalor);

        $item->foto;

        if ($item->foto == "--" || $item->foto == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->foto;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }



    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
