<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Campolaboral;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;

class CampoLaboralController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.nosotros.mision_vision_valores.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idprograma = $request->input('idprogram');

            $data = DB::table('pe_campo_laboral as cl')
            ->select(
                'cl.id as id',
                'cl.texto as texto',
                'cl.imagen as imagen',
                'cl.programa_estudio_id as programa_estudio_id'
            )
            ->where('cl.programa_estudio_id', $idprograma)
            ->get();


            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen_cl' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen_cl.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen_cl.max' => 'El tamaño del archivo no debe superar los 50 MB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {


            // nuevo objeto
            $item = new Campolaboral();

            $item->texto = $request->input('txt-texto_cl');
            $item->programa_estudio_id = $request->input('txt-programa_estudio_id_cl');

            $item->save();

            $idcampolaboral = $item->id;
            $idprograma = $item->programa_estudio_id;

            // guardar documento si existe
            if ($request->hasFile('txt-imagen_cl')) {
                $folderName =  'public/programas_estudios/gestionar_pe/'. $idprograma . '/' . 'campo_laboral/' . $idcampolaboral;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen_cl');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-imagen_cl' => 'mimes:jpg,png,jpeg|max:50000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-imagen_cl.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-imagen_cl.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);

        } else {


            $item = Campolaboral::find($request->input('txt-idcampolaboral'));

            $item->texto = $request->input('txt-texto_cl');

            $idcampolaboral = $item->id;
            $idprograma = $item->programa_estudio_id;

            // guardar documento si existe
            if ($request->hasFile('txt-imagen_cl')) {
                $ruta = $item->imagen;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $folderName =  'public/programas_estudios/gestionar_pe/'. $idprograma . '/' . 'campo_laboral/' . $idcampolaboral;
                Storage::disk('local')->makeDirectory(''.$folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-imagen_cl');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'imagen.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'imagen.' . $extension;  // ruta del archivo
                $item->imagen = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }

    }


    public function destroy($id)
    {

        $item = Campolaboral::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $ruta = $item->imagen;

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ver_imagenCampoLaboral($idcampolaboral)
    {
        $item = Campolaboral::find($idcampolaboral);

        $item->imagen;

        if ($item->imagen == "--" || $item->imagen == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
        }

        $file = storage_path('app/') . $item->imagen;

        if (file_exists($file)) {
            return $this->funcion_verImagen($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verImagen($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verImagen($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf': $contentType = 'application/pdf'; break;
            case 'png': $contentType = 'image/png'; break;
            case 'jpg':
            case 'jpeg': $contentType = 'image/jpeg'; break;
            default: abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
