<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\InicioBeneficios;
use App\Http\Controllers\sidebar\SidebarController;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class BeneficioController extends Controller
{


    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.inicio.beneficios.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('inicio_beneficios as ib')
                ->select(
                    'ib.id',
                    'ib.fotoicono',
                    'ib.descripcion',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = InicioBeneficios::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // Verificar la cantidad actual de beneficios
        $count = InicioBeneficios::count();

        // Validar si ya hay 8 registros
        if ($count >= 8) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Máximo de 8 beneficios alcanzados.',
            ]);
        }

        // validar fotoicono
        $validator = Validator::make($request->all(), [
            'txt-fotoicono' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-fotoicono.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-fotoicono.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            // nuevo objeto
            $item = new InicioBeneficios();
            $item->descripcion = $request->input('txt-descripcion');
            $item->save();
            $idfotoicono = $item->id;

            // guardar fotoicono si existe
            if ($request->hasFile('txt-fotoicono')) {
                $folderName =  'public/inicio/beneficios/' . $idfotoicono;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-fotoicono');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'fotoicono.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'fotoicono.' . $extension;  // ruta del archivo
                $item->fotoicono = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update(Request $request, $id)
    {
        // validar fotoicono
        $validator = Validator::make($request->all(), [
            'txt-fotoicono' => 'mimes:jpg,png,jpeg|max:5000', // Valida jpg y tamaño máximo de 2MB
        ], [
            'txt-fotoicono.mimes' => 'El archivo debe ser en formato jpg o png.',
            'txt-fotoicono.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ], 422);
        } else {

            $item = InicioBeneficios::find($id);
            $item->descripcion = $request->input('txt-descripcion');

            // guardar fotoicono si existe
            if ($request->hasFile('txt-fotoicono')) {

                // DEBE IR DENTRO DEL IF SINO SE ELIMINARA ANTES
                $ruta = $item->fotoicono;

                $file = storage_path('app/') . $ruta;
                if (File::exists($file)) {
                    File::delete($file);
                }

                $idfotoicono = $item->id;
                // DEBE IR DENTRO DEL IF SINO SE ELIMINARA ANTES


                $folderName =  'public/inicio/beneficios/' . $idfotoicono;
                Storage::disk('local')->makeDirectory('' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-fotoicono');   // obtenemos el archivo
                $extension = $archivo->getClientOriginalExtension();
                $archivo->storeAs($folderName, 'fotoicono.' . $extension);  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'fotoicono.' . $extension;  // ruta del archivo
                $item->fotoicono = $filePath;
            }

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {

        $item = InicioBeneficios::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $fotoicono = $item->fotoicono;

        $file = storage_path('app/') . $fotoicono;
        if (File::exists($file)) {
            File::delete($file);
        }

        $archivo = $item->fotoicono;
        $file = storage_path('app/') . $archivo;
        if (File::exists($file)) {
            File::delete($file);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function ver_foto_icono($idvalor)
    {
        $item = InicioBeneficios::find($idvalor);

        $item->fotoicono;

        if ($item->fotoicono == "--" || $item->fotoicono == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->fotoicono;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'contract.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
