<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Http\Controllers\sidebar\SidebarController;

use App\Models\Becas;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;

class BecasController extends Controller
{

    //ACCESO VISTA ADMIN
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.admision_matricula.becas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function combo_programas(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('programas_estudios as pe')
                ->select(
                    'pe.id as idprograma',
                    'pe.nombre as nombre_programa'
                )
                ->orderBy('pe.nombre')
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }

    public function list(Request $request, $variable)
    {

        $idprogramaestudio = $request->input('idprogramaestudio');

        if ($request->ajax()) {

            $data = DB::table('becas as b')
                ->select(
                    'b.id',
                    'b.programa_estudio_id',
                    'b.nombre',
                    'b.tipo',
                )
                ->where('b.programa_estudio_id', $idprogramaestudio)

                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = Becas::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    // public function store(Request $request, $dt_idtitulorequisitos)
    // {
    //     // Se recoge el id que pasa al js y luego admin store el id y lo recojo aqui
    //     $idtitulorequisitos = $dt_idtitulorequisitos;

    //     // Nuevo objeto
    //     $item = new Becas();

    //     $item->id_titulo = $idtitulorequisitos;
    //     $item->descripcion = $request->input('txt-descripcion');

    //     if ($item->save()) {
    //         return response()->json(["status" => true, "mensaje" => 'Se ingresó el nuevo registro']);
    //     } else {
    //         return response()->json(["status" => false, "mensaje" => 'No se logró ingresar el nuevo registro']);
    //     }
    // }

    public function store(Request $request)
    {
        // Nuevo objeto
        $item = new Becas();

        $item->programa_estudio_id = $request->input('txt-programa_estudio_id');
        $item->nombre = $request->input('txt-nombre');
        $item->tipo = $request->input('txt-tipo');

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Se ingresó el nuevo registro']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'No se logró ingresar el nuevo registro']);
        }
    }




    public function update(Request $request, $id)
    {

        $item = Becas::find($id);

        $item->programa_estudio_id = $request->input('txt-programa_estudio_id');
        $item->nombre = $request->input('txt-nombre');
        $item->tipo = $request->input('txt-tipo');

        $item->save();

        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {

        $item = Becas::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
