<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Models\AdmisionVacantes;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\sidebar\SidebarController;


class AdmisionVacantesController extends Controller
{

    //ACCESO VISTA ADMIN
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar

                return view('admin.admision_matricula.admision.vacantes')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else {
                return redirect()->route('login')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function combo_programas(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('programas_estudios as pe')
                ->select(
                    'pe.id as idprograma',
                    'pe.nombre as nombre_programa'
                )
                ->orderBy('pe.nombre')
                ->get();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function list(Request $request, $variable)
    {
        if ($request->ajax()) {

            $data = DB::table('admision_vacantes as av')
                ->select(
                    'av.id',
                    'av.programa',
                    'av.vacantes',
                )
                ->get();

            if ($variable == "tabla") {
                // datatable
                return DataTables::of($data)
                    ->addIndexColumn()
                    ->make(true);
            } else if ($variable == "div") {
                return response()->json($data);
            } else if ($variable >= 0) {
                $item = AdmisionVacantes::find($variable);
                return response()->json($item);
            }
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }


    public function store(Request $request)
    {
        // Validar la entrada
        $request->validate([
            'txt-programa' => 'required|string|max:255',
            'txt-vacantes' => 'required|string|max:255', // Asumiendo que vacantes es texto
        ]);

        // Verificar si el programa ya existe
        $existingProgram = AdmisionVacantes::where('programa', $request->input('txt-programa'))->first();

        if ($existingProgram) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El programa de estudio ya existe.'
            ]);
        }

        // Nuevo objeto
        $item = new AdmisionVacantes();
        $item->programa = $request->input('txt-programa');
        $item->vacantes = $request->input('txt-vacantes');

        if ($item->save()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Se ingresó el nuevo registro.'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se logró ingresar el nuevo registro.'
            ]);
        }
    }




    public function update(Request $request, $id)
    {
        // Validar la entrada
        $request->validate([
            'txt-programa' => 'required|string|max:255',
            'txt-vacantes' => 'required|string|max:255', // Asumiendo que vacantes es texto
        ]);

        // Obtener el registro a actualizar
        $item = AdmisionVacantes::find($id);

        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'Registro no encontrado']);
        }

        // Verificar si el nuevo programa ya existe, excluyendo el registro actual
        $existingProgram = AdmisionVacantes::where('programa', $request->input('txt-programa'))
            ->where('id', '!=', $id)
            ->first();

        if ($existingProgram) {
            return response()->json(["status" => false, "mensaje" => 'El programa de estudio ya existe.']);
        }

        // Actualizar los campos
        $item->programa = $request->input('txt-programa');
        $item->vacantes = $request->input('txt-vacantes');

        // Guardar cambios
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }




    public function destroy($id)
    {

        $item = AdmisionVacantes::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
