<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Hash;

class AdministratorProfileController extends Controller
{

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.profile.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('datalist', $sidebar);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function data(Request $request)
    {
        $iduser = Auth::user()->id;

        if ($request->ajax()) {

            $data = DB::table('usuarios as us')
                ->select(
                    'us.id as iduser',
                    'us.nroidenti as codigo',
                    'us.nombres as nombre',
                    'us.apellido_pa as apellido_pa',
                    'us.apellido_ma as apellido_ma',
                    'us.correo as correo',
                    'us.celular as celular',
                    'us.estado as estado'
                )
                ->where('us.id', '=', $iduser)
                ->get();

                return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function update(Request $request)
    {
        $id = Auth::user()->id;

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            $item->tipoidenti = $request->input('txt-tipoidenti');
            $item->nroidenti = $request->input('txt-codigo');
            $item->nombres = $request->input('txt-nombre');
            $item->apellido_pa = $request->input('txt-apellido_pa');
            $item->apellido_ma = $request->input('txt-apellido_ma');
            $item->correo = $request->input('txt-correo');
            $item->celular = $request->input('txt-celular');

            // validar guardado
            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Datos actualizados']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Datos no actualizados']);
            }
        }
    }

    public function update_password(Request $request)
    {
        $id = Auth::user()->id;
        $password = Auth::user()->password;
        $pass_actual = $request->input('txt-password1');
        $pass_nueva = $request->input('txt-password2');

        if ( Hash::check($pass_actual, $password) ) {

            $item = User::find($id);

            // validar existencia del registro
            if (!$item) {
                abort(404);
            } else {
                // recoger datos
                $item->password = $pass_nueva;
                // validar guardado
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                }
            }

        } else {
            return response()->json([
                "status" => false,
                "errors" => ["Credenciales inválidas"]
            ]);
        }


    }
}
