<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class AdministratorController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {

            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            if ($userTypeAccesocombo == "1") {
                $tipoacceso = 1;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.seguridad.administradores.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('datalist', $sidebar);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('usuarios AS u')
                ->join('roles AS r', 'r.id', '=', 'u.role_id')
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->get([
                    'r.id AS idrole',
                    'r.nombre AS nombrerole',
                    'u.id AS iduser',
                    'u.tipoidenti',
                    'u.nroidenti',
                    'u.password',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'),
                    'u.correo',
                    'u.celular',
                    'u.estado',
                ]);
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {
        // nuevo objeto
        $item = new User();
        // setear datos
        $item->tipoidenti = $request->input('txt-tipoidenti');
        $item->nroidenti = $request->input('txt-nroidenti');
        $item->password = $request->input('txt-password');
        $item->nombres = ucwords(strtolower($request->input('txt-nombres')));
        $item->apellido_pa = ucwords(strtolower($request->input('txt-apellido_pa')));
        $item->apellido_ma = ucwords(strtolower($request->input('txt-apellido_ma')));
        $item->correo = $request->input('txt-correo');
        $item->celular = $request->input('txt-celular');
        $item->role_id = $request->input('txt-role_id');
        $item->estado = $request->input('txt-estado');

        // validar guardado
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {

        $item = User::find($id);

        // setear datos
        $item->tipoidenti = $request->input('txt-tipoidenti');
        $item->nroidenti = $request->input('txt-nroidenti');
        $item->password = $request->input('txt-password');
        $item->nombres = ucwords(strtolower($request->input('txt-nombres')));
        $item->apellido_pa = ucwords(strtolower($request->input('txt-apellido_pa')));
        $item->apellido_ma = ucwords(strtolower($request->input('txt-apellido_ma')));
        $item->correo = $request->input('txt-correo');
        $item->celular = $request->input('txt-celular');
        $item->role_id = $request->input('txt-role_id');
        $item->estado = $request->input('txt-estado');

        // validar guardado
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update_password(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt-password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }



    public function destroy($id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }



    public function query_data($nroidenti)
    {
        $token = 'apis-token-6194.hK3hbzBDyBDl6XqMq1idxOEs8zNDv6AJ';

        // Iniciar llamada a API
        $curl = curl_init();

        // Buscar ruc sunat
        curl_setopt_array($curl, array(
            // para usar la versión 2
            CURLOPT_URL => 'https://api.apis.net.pe/v2/reniec/dni?numero=' . $nroidenti,
            // para usar la versión 1
            // CURLOPT_URL => 'https://api.apis.net.pe/v1/ruc?numero=' . $ruc,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Referer: http://apis.net.pe/api-ruc',
                'Authorization: Bearer ' . $token
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // Datos de empresas según padron reducido


        return response()->json([
            "status" => true,
            "mensaje" => 'Consulta realizada',
            "data" => $response
        ]);
    }
}
